module net.BurtonRadons.spyl.scope;

/** A storage for symbols. */
class Scope
{
    private import net.BurtonRadons.spyl.value;
  
    Scope [] imports; /**< Other referenced scopes. */
    Value [char []] symbols; /**< Symbols defined in this scope. */
    
    /** Add this scope to the imports. */
    void add (Scope scope)
    {
        imports ~= scope;
    }
    
    /** Try to assign a value to this scope.  If it doesn't exist here, try it in the parent
      * scopes.  Return whether any of them got it.
      */
      
    bit tryAssign (char [] name, Value value)
    {
        if (name in symbols)
        {
            symbols [name] = value;
            return true;
        }
        
        for (int c; c < imports.length; c ++)
            if (imports [c].tryAssign (name, value))
                return true;
            
        return false;
    }
    
    /** Assign a value. */
    void assign (char [] name, Value value)
    {
        if (!tryAssign (name, value))
            symbols [name] = value;
    }
    
    /** Try to retrieve a value. */
    Value tryRetrieve (char [] name)
    {
        Value result;
        
        if (name in symbols)
            return symbols [name];
        for (int c; c < imports.length; c ++)
            if ((result = imports [c].tryRetrieve (name)) !== null)
                return result;
            
        return null;
    }
    
    /** Retrieve a value or throw an error if it couldn't be found. */
    Value retrieve (char [] name)
    {
        Value result;
        
        result = tryRetrieve (name);
        if (result === null)
            throw new Error ("Cannot find identifier " ~ name ~ ".");
        return result;
    }
}
